<?php
require_once __DIR__.'/middleware.php';
$title = 'Subcategories — '.APP_NAME;
$mysqli = db();

if ($_SERVER['REQUEST_METHOD']==='POST') {
  if (isset($_POST['create'])) {
    $name = trim($_POST['name'] ?? ''); $cat = (int)($_POST['category_id'] ?? 0);
    if ($name && $cat) {
      $slug = strtolower(preg_replace('/[^a-z0-9]+/i','-', $name));
      $stmt = $mysqli->prepare("INSERT INTO subcategories(category_id, name, slug) VALUES (?,?,?)");
      $stmt->bind_param('iss', $cat, $name, $slug);
      $stmt->execute();
      flash('msg', 'Subcategory added.');
    }
  }
  if (isset($_POST['update'])) {
    $id=(int)$_POST['id']; $name=trim($_POST['name']??''); $cat=(int)($_POST['category_id'] ?? 0);
    if ($id && $name && $cat) {
      $slug = strtolower(preg_replace('/[^a-z0-9]+/i','-', $name));
      $stmt = $mysqli->prepare("UPDATE subcategories SET category_id=?, name=?, slug=? WHERE id=?");
      $stmt->bind_param('issi', $cat, $name, $slug, $id);
      $stmt->execute(); flash('msg','Subcategory updated.');
    }
  }
  if (isset($_POST['delete'])) {
    $id=(int)$_POST['id']; $stmt=$mysqli->prepare("UPDATE subcategories SET deleted=1 WHERE id=?"); $stmt->bind_param('i',$id); $stmt->execute(); flash('msg','Subcategory trashed.');
  }
  if (isset($_POST['restore'])) { $id=(int)$_POST['id']; $stmt=$mysqli->prepare("UPDATE subcategories SET deleted=0 WHERE id=?"); $stmt->bind_param('i',$id); $stmt->execute(); flash('msg','Subcategory restored.'); }
  redirect('/admin/subcategories.php');
}

$cats = $mysqli->query("SELECT id, name FROM categories WHERE deleted=0 ORDER BY name");
$mapCats = []; while($c=$cats->fetch_assoc()) $mapCats[$c['id']]=$c['name'];
$rows = $mysqli->query("SELECT * FROM subcategories ORDER BY deleted ASC, id DESC");
?>
<!doctype html><html><head>
<meta charset="utf-8"><meta name="viewport" content="width=device-width,initial-scale=1">
<title><?= esc($title) ?></title>
<link rel="stylesheet" href="<?= BASE_URL ?>/admin/assets/admin.css">
</head><body><div class="wrap">
  <div class="topbar">
    <h2>Subcategories</h2>
    <div><a class="badge" href="<?= BASE_URL ?>/admin/dashboard.php">Back</a></div>
  </div>
  <?php if ($m=flash('msg')): ?><div class="alert"><?= esc($m) ?></div><?php endif; ?>
  <form method="post" class="card" style="padding:16px;margin-bottom:16px">
    <div class="form-grid">
      <p><label>Name</label><br><input class="input" name="name" required></p>
      <p><label>Category</label><br>
        <select name="category_id" class="input" required>
          <option value="">Select…</option>
          <?php foreach($mapCats as $id=>$nm): ?><option value="<?= (int)$id ?>"><?= esc($nm) ?></option><?php endforeach; ?>
        </select>
      </p>
    </div>
    <button class="btn" name="create">Add Subcategory</button>
  </form>
  <table class="table">
    <tr><th>ID</th><th>Name</th><th>Category</th><th>Slug</th><th>Status</th><th>Actions</th></tr>
    <?php while($r=$rows->fetch_assoc()): ?>
      <tr>
        <td><?= (int)$r['id'] ?></td>
        <td><?= esc($r['name']) ?></td>
        <td><?= esc($mapCats[$r['category_id']] ?? '-') ?></td>
        <td><?= esc($r['slug']) ?></td>
        <td><?= $r['deleted'] ? 'Trashed' : 'Active' ?></td>
        <td>
          <form method="post" style="display:inline">
            <input type="hidden" name="id" value="<?= (int)$r['id'] ?>">
            <input class="input" name="name" value="<?= esc($r['name']) ?>" style="width:160px">
            <select name="category_id" class="input">
              <?php foreach($mapCats as $id=>$nm): ?><option value="<?= (int)$id ?>" <?= $id==$r['category_id']?'selected':'' ?>><?= esc($nm) ?></option><?php endforeach; ?>
            </select>
            <button class="btn secondary" name="update">Update</button>
          </form>
          <?php if (!$r['deleted']): ?>
            <form method="post" style="display:inline"><input type="hidden" name="id" value="<?= (int)$r['id'] ?>"><button class="btn" name="delete">Trash</button></form>
          <?php else: ?>
            <form method="post" style="display:inline"><input type="hidden" name="id" value="<?= (int)$r['id'] ?>"><button class="btn" name="restore">Restore</button></form>
          <?php endif; ?>
        </td>
      </tr>
    <?php endwhile; ?>
  </table>
</div></body></html>