<?php
require_once __DIR__.'/../init.php';
$slug = $_GET['slug'] ?? '';
$mysqli = db();
$stmt = $mysqli->prepare("SELECT id, name FROM categories WHERE slug=? AND deleted=0");
$stmt->bind_param('s', $slug);
$stmt->execute(); $cat = $stmt->get_result()->fetch_assoc();
if (!$cat) { http_response_code(404); $title='Category Not Found'; include __DIR__.'/partials/header.php'; echo "<p>Category not found.</p>"; include __DIR__.'/partials/footer.php'; exit; }
$title = esc($cat['name']).' — Category';
include __DIR__.'/partials/header.php';

$posts = $mysqli->prepare("SELECT id, title, slug, image, created_at FROM posts WHERE status='published' AND category_id=? ORDER BY id DESC");
$posts->bind_param('i', $cat['id']);
$posts->execute(); $rs = $posts->get_result();
?>
<h2><?= esc($cat['name']) ?></h2>
<div class="grid">
<?php while($p = $rs->fetch_assoc()): ?>
  <a class="card" href="post.php?slug=<?= esc($p['slug']) ?>">
    <img src="<?= BASE_URL ?>/public/assets/images/<?= esc($p['image'] ?: 'world1.jpg') ?>" alt="">
    <div class="pad">
      <div class="meta"><span class="badge"><?= esc($cat['name']) ?></span><span><?= date('M j, Y', strtotime($p['created_at'])) ?></span></div>
      <h3><?= esc($p['title']) ?></h3>
    </div>
  </a>
<?php endwhile; ?>
</div>
<?php include __DIR__.'/partials/footer.php'; ?>