<?php
require_once __DIR__.'/../init.php';
$title = APP_NAME.' — Latest News';
include __DIR__.'/partials/header.php';

$mysqli = db();
// categories
$cats = $mysqli->query("SELECT id, name, slug FROM categories WHERE deleted=0 ORDER BY name ASC");
// latest posts
$posts = $mysqli->query("SELECT p.id, p.title, p.slug, p.image, p.created_at, c.name cat FROM posts p LEFT JOIN categories c ON c.id=p.category_id WHERE p.status='published' ORDER BY p.id DESC LIMIT 8");
?>
<section class="hero">
  <h1>Stay ahead with trusted news.</h1>
  <p>Real-time coverage across World, Technology, Sports, and Entertainment — curated for you.</p>
</section>

<h3 class="kicker" style="margin-top:22px">Categories</h3>
<div class="cat-list">
<?php while($c = $cats->fetch_assoc()): ?>
  <a class="badge" href="category.php?slug=<?= esc($c['slug']) ?>"><?= esc($c['name']) ?></a>
<?php endwhile; ?>
</div>

<h3 class="kicker" style="margin-top:22px">Latest</h3>
<div class="grid">
<?php while($p = $posts->fetch_assoc()): ?>
  <a class="card" href="post.php?slug=<?= esc($p['slug']) ?>">
    <img src="<?= BASE_URL ?>/public/assets/images/<?= esc($p['image'] ?: 'world1.jpg') ?>" alt="">
    <div class="pad">
      <div class="meta"><span class="badge"><?= esc($p['cat'] ?: 'General') ?></span><span><?= date('M j, Y', strtotime($p['created_at'])) ?></span></div>
      <h3><?= esc($p['title']) ?></h3>
      <div><span class="btn secondary">Read more</span></div>
    </div>
  </a>
<?php endwhile; ?>
</div>
<?php include __DIR__.'/partials/footer.php'; ?>