<?php
require_once __DIR__.'/middleware.php';
$title = 'Pages — '.APP_NAME;
$mysqli = db();

if ($_SERVER['REQUEST_METHOD']==='POST') {
  $slug = $_POST['slug'] ?? '';
  $titleP = $_POST['title'] ?? '';
  $body = $_POST['body'] ?? '';
  if ($slug && $titleP) {
    $stmt = $mysqli->prepare("INSERT INTO pages(slug,title,body) VALUES (?,?,?) ON DUPLICATE KEY UPDATE title=VALUES(title), body=VALUES(body)");
    $stmt->bind_param('sss', $slug, $titleP, $body);
    $stmt->execute();
    flash('msg','Page saved.');
  }
  redirect('/admin/pages.php');
}

$pages = $mysqli->query("SELECT * FROM pages ORDER BY slug");
$map = []; while($p=$pages->fetch_assoc()) $map[$p['slug']]=$p;
$slugs = ['about','contact'];
?>
<!doctype html><html><head>
<meta charset="utf-8"><meta name="viewport" content="width=device-width,initial-scale=1">
<title><?= esc($title) ?></title>
<link rel="stylesheet" href="<?= BASE_URL ?>/admin/assets/admin.css">
</head><body><div class="wrap">
  <div class="topbar"><h2>Pages</h2><div><a class="badge" href="<?= BASE_URL ?>/admin/dashboard.php">Back</a></div></div>
  <?php if ($m=flash('msg')): ?><div class="alert"><?= esc($m) ?></div><?php endif; ?>

  <?php foreach($slugs as $s): $p=$map[$s]??['slug'=>$s,'title'=>ucfirst($s),'body'=>'']; ?>
    <form method="post" class="card" style="padding:16px;margin-bottom:16px">
      <input type="hidden" name="slug" value="<?= esc($s) ?>">
      <h3><?= ucfirst($s) ?> Page</h3>
      <p><label>Title</label><br><input class="input" name="title" value="<?= esc($p['title']) ?>"></p>
      <p><label>Body (HTML allowed)</label><br><textarea class="input" name="body" rows="6"><?= esc($p['body']) ?></textarea></p>
      <button class="btn">Save</button>
    </form>
  <?php endforeach; ?>
</div></body></html>