<?php
require_once __DIR__.'/middleware.php';
$title = 'Posts — '.APP_NAME;
$mysqli = db();

if ($_SERVER['REQUEST_METHOD']==='POST') {
  if (isset($_POST['create'])) {
    $titleV = trim($_POST['title'] ?? '');
    $cat = (int)($_POST['category_id'] ?? 0);
    $sub = $_POST['subcategory_id'] ? (int)$_POST['subcategory_id'] : null;
    $body = $_POST['body'] ?? '';
    $image = trim($_POST['image'] ?? '');
    if ($titleV && $cat && $body) {
      $slug = strtolower(preg_replace('/[^a-z0-9]+/i','-', $titleV.'-'.uniqid()));
      $stmt = $mysqli->prepare("INSERT INTO posts(category_id, subcategory_id, title, slug, image, body, status) VALUES (?,?,?,?,?,?,'published')");
      $stmt->bind_param('iissss', $cat, $sub, $titleV, $slug, $image, $body);
      $stmt->execute();
      flash('msg','Post created.');
    }
  }
  if (isset($_POST['update'])) {
    $id=(int)$_POST['id']; $titleV=trim($_POST['title']??''); $cat=(int)($_POST['category_id']??0);
    $sub=$_POST['subcategory_id']? (int)$_POST['subcategory_id'] : null; $body=$_POST['body']??''; $image=trim($_POST['image']??'');
    if ($id && $titleV && $cat) {
      $stmt = $mysqli->prepare("UPDATE posts SET category_id=?, subcategory_id=?, title=?, image=?, body=? WHERE id=?");
      $stmt->bind_param('iisssi', $cat, $sub, $titleV, $image, $body, $id);
      $stmt->execute(); flash('msg','Post updated.');
    }
  }
  if (isset($_POST['trash'])) {
    $id=(int)$_POST['id']; $stmt=$mysqli->prepare("UPDATE posts SET status='trashed' WHERE id=?"); $stmt->bind_param('i',$id); $stmt->execute(); flash('msg','Post trashed.');
  }
  if (isset($_POST['restore'])) {
    $id=(int)$_POST['id']; $stmt=$mysqli->prepare("UPDATE posts SET status='published' WHERE id=?"); $stmt->bind_param('i',$id); $stmt->execute(); flash('msg','Post restored.');
  }
  redirect('/admin/posts.php');
}

$cats = $mysqli->query("SELECT id, name FROM categories WHERE deleted=0 ORDER BY name");
$catMap=[]; while($c=$cats->fetch_assoc()) $catMap[$c['id']]=$c['name'];
$subs = $mysqli->query("SELECT id, name, category_id FROM subcategories WHERE deleted=0 ORDER BY name");
$subGroup = [];
while($s=$subs->fetch_assoc()) $subGroup[$s['category_id']][]=$s;

$posts = $mysqli->query("SELECT p.*, c.name cat FROM posts p LEFT JOIN categories c ON c.id=p.category_id ORDER BY p.id DESC");
?>
<!doctype html><html><head>
<meta charset="utf-8"><meta name="viewport" content="width=device-width,initial-scale=1">
<title><?= esc($title) ?></title>
<link rel="stylesheet" href="<?= BASE_URL ?>/admin/assets/admin.css">
</head><body><div class="wrap">
  <div class="topbar">
    <h2>Posts</h2>
    <div><a class="badge" href="<?= BASE_URL ?>/admin/dashboard.php">Back</a></div>
  </div>
  <?php if ($m=flash('msg')): ?><div class="alert"><?= esc($m) ?></div><?php endif; ?>

  <form method="post" class="card" style="padding:16px;margin-bottom:16px">
    <h3>Create Post</h3>
    <div class="form-grid">
      <p><label>Title</label><br><input class="input" name="title" required></p>
      <p><label>Image filename (from /public/assets/images)</label><br><input class="input" name="image" placeholder="e.g., tech1.jpg"></p>
      <p><label>Category</label><br>
        <select class="input" name="category_id" required>
          <option value="">Select…</option>
          <?php foreach($catMap as $id=>$nm): ?><option value="<?= (int)$id ?>"><?= esc($nm) ?></option><?php endforeach; ?>
        </select>
      </p>
      <p><label>Subcategory</label><br>
        <select class="input" name="subcategory_id">
          <option value="">(optional)</option>
          <?php foreach($subGroup as $cid=>$list): foreach($list as $s): ?>
            <option value="<?= (int)$s['id'] ?>"><?= esc(($catMap[$cid]??'-')." / ".$s['name']) ?></option>
          <?php endforeach; endforeach; ?>
        </select>
      </p>
    </div>
    <p><label>Body (HTML allowed)</label><br><textarea class="input" name="body" rows="6" required></textarea></p>
    <button class="btn" name="create">Publish</button>
  </form>

  <table class="table">
    <tr><th>ID</th><th>Title</th><th>Category</th><th>Status</th><th>Image</th><th>Actions</th></tr>
    <?php while($r=$posts->fetch_assoc()): ?>
      <tr>
        <td><?= (int)$r['id'] ?></td>
        <td><?= esc($r['title']) ?></td>
        <td><?= esc($r['cat'] ?: '-') ?></td>
        <td><?= esc($r['status']) ?></td>
        <td><?= esc($r['image'] ?: '-') ?></td>
        <td>
          <details>
            <summary class="badge">Edit</summary>
            <form method="post" style="padding:8px;background:rgba(255,255,255,.04);border-radius:10px;margin-top:8px">
              <input type="hidden" name="id" value="<?= (int)$r['id'] ?>">
              <p><input class="input" name="title" value="<?= esc($r['title']) ?>"></p>
              <p><input class="input" name="image" value="<?= esc($r['image']) ?>" placeholder="image filename"></p>
              <p>
                <select class="input" name="category_id">
                  <?php foreach($catMap as $id=>$nm): ?><option value="<?= (int)$id ?>" <?= $id==$r['category_id']?'selected':'' ?>><?= esc($nm) ?></option><?php endforeach; ?>
                </select>
              </p>
              <p><textarea class="input" name="body" rows="4"><?= esc($r['body']) ?></textarea></p>
              <button class="btn secondary" name="update">Save</button>
              <?php if ($r['status']==='published'): ?>
                <button class="btn" name="trash">Trash</button>
              <?php else: ?>
                <button class="btn" name="restore">Restore</button>
              <?php endif; ?>
            </form>
          </details>
        </td>
      </tr>
    <?php endwhile; ?>
  </table>
</div></body></html>