<?php
require_once __DIR__.'/../init.php';
require_admin();
$title = 'Sub-Admins — '.APP_NAME;
$mysqli = db();

if ($_SERVER['REQUEST_METHOD']==='POST') {
  if (isset($_POST['create'])) {
    $name=trim($_POST['name']??''); $email=trim($_POST['email']??''); $password=trim($_POST['password']??'');
    if ($name && $email && $password) {
      $hash = password_hash($password, PASSWORD_BCRYPT);
      $stmt=$mysqli->prepare("INSERT INTO users(name,email,password_hash,role) VALUES (?,?,?,'subadmin')");
      $stmt->bind_param('sss', $name, $email, $hash);
      $stmt->execute(); flash('msg','Sub-admin created.');
    }
  }
  if (isset($_POST['delete'])) {
    $id=(int)$_POST['id'];
    // prevent deleting self if admin
    if ($id != ($_SESSION['user_id'] ?? 0)) {
      $stmt=$mysqli->prepare("DELETE FROM users WHERE id=? AND role='subadmin'");
      $stmt->bind_param('i',$id); $stmt->execute(); flash('msg','Sub-admin deleted.');
    } else {
      flash('msg','You cannot delete yourself.');
    }
  }
  redirect('/admin/subadmins.php');
}

$rows = $mysqli->query("SELECT id, name, email, role, created_at FROM users WHERE role='subadmin' ORDER BY id DESC");
?>
<!doctype html><html><head>
<meta charset="utf-8"><meta name="viewport" content="width=device-width,initial-scale=1">
<title><?= esc($title) ?></title>
<link rel="stylesheet" href="<?= BASE_URL ?>/admin/assets/admin.css">
</head><body><div class="wrap">
  <div class="topbar"><h2>Sub-Admins</h2><div><a class="badge" href="<?= BASE_URL ?>/admin/dashboard.php">Back</a></div></div>
  <?php if ($m=flash('msg')): ?><div class="alert"><?= esc($m) ?></div><?php endif; ?>

  <form method="post" class="card" style="padding:16px;margin-bottom:16px">
    <h3>Create Sub-Admin</h3>
    <div class="form-grid">
      <p><label>Name</label><br><input class="input" name="name" required></p>
      <p><label>Email</label><br><input class="input" type="email" name="email" required></p>
    </div>
    <p><label>Password</label><br><input class="input" type="text" name="password" value="Sub@<?= rand(1000,9999) ?>" required></p>
    <button class="btn" name="create">Create</button>
  </form>

  <table class="table">
    <tr><th>ID</th><th>Name</th><th>Email</th><th>Role</th><th>Joined</th><th>Actions</th></tr>
    <?php while($r=$rows->fetch_assoc()): ?>
      <tr>
        <td><?= (int)$r['id'] ?></td>
        <td><?= esc($r['name']) ?></td>
        <td><?= esc($r['email']) ?></td>
        <td><?= esc($r['role']) ?></td>
        <td><?= esc($r['created_at']) ?></td>
        <td>
          <form method="post" style="display:inline"><input type="hidden" name="id" value="<?= (int)$r['id'] ?>"><button class="btn" name="delete">Delete</button></form>
        </td>
      </tr>
    <?php endwhile; ?>
  </table>
</div></body></html>