<?php
require_once __DIR__.'/../init.php';
$slug = $_GET['slug'] ?? '';
$mysqli = db();
$stmt = $mysqli->prepare("SELECT p.*, c.name cat FROM posts p LEFT JOIN categories c ON c.id=p.category_id WHERE p.slug=? AND p.status='published'");
$stmt->bind_param('s', $slug);
$stmt->execute(); $post = $stmt->get_result()->fetch_assoc();
if (!$post) { http_response_code(404); $title='Post Not Found'; include __DIR__.'/partials/header.php'; echo "<p>Post not found.</p>"; include __DIR__.'/partials/footer.php'; exit; }
$title = esc($post['title']).' — '.APP_NAME;
include __DIR__.'/partials/header.php';

// related
$r = $mysqli->prepare("SELECT title, slug, image FROM posts WHERE category_id=? AND id<>? AND status='published' ORDER BY id DESC LIMIT 3");
$r->bind_param('ii', $post['category_id'], $post['id']);
$r->execute(); $related = $r->get_result();

// comments
$c = $mysqli->prepare("SELECT author_name, body, created_at FROM comments WHERE post_id=? AND status='approved' ORDER BY id DESC");
$c->bind_param('i', $post['id']);
$c->execute(); $comments = $c->get_result();
?>
<article class="card" style="overflow:hidden">
  <img src="<?= BASE_URL ?>/public/assets/images/<?= esc($post['image'] ?: 'world1.jpg') ?>" alt="">
  <div class="pad">
    <div class="meta"><span class="badge"><?= esc($post['cat'] ?: 'General') ?></span><span><?= date('M j, Y', strtotime($post['created_at'])) ?></span></div>
    <h1 style="margin:.3rem 0 1rem"><?= esc($post['title']) ?></h1>
    <div><?= $post['body'] ?></div>
  </div>
</article>

<h3 style="margin-top:24px">Leave a comment</h3>
<?php if ($msg = flash('cmsg')): ?><div class="alert"><?= esc($msg) ?></div><?php endif; ?>
<form method="post" action="submit_comment.php">
  <input type="hidden" name="post_id" value="<?= (int)$post['id'] ?>">
  <div class="form-row">
    <p><input class="input" name="name" placeholder="Your name" required></p>
    <p><input class="input" type="email" name="email" placeholder="Email" required></p>
  </div>
  <p><textarea class="input" name="body" rows="5" placeholder="Your comment" required></textarea></p>
  <button class="btn" type="submit">Submit</button>
</form>

<h3 style="margin-top:24px">Comments</h3>
<?php if ($comments->num_rows===0): ?>
  <p class="muted">No comments yet.</p>
<?php endif; ?>
<div>
<?php while($cm = $comments->fetch_assoc()): ?>
  <div class="card" style="margin-bottom:10px">
    <div class="pad">
      <div class="meta"><span class="badge"><?= esc($cm['author_name']) ?></span><span><?= date('M j, Y', strtotime($cm['created_at'])) ?></span></div>
      <div><?= esc($cm['body']) ?></div>
    </div>
  </div>
<?php endwhile; ?>
</div>

<h3 style="margin-top:24px">Related</h3>
<div class="grid">
<?php while($rp = $related->fetch_assoc()): ?>
  <a class="card" href="post.php?slug=<?= esc($rp['slug']) ?>">
    <img src="<?= BASE_URL ?>/public/assets/images/<?= esc($rp['image'] ?: 'world1.jpg') ?>" alt="">
    <div class="pad"><h3><?= esc($rp['title']) ?></h3></div>
  </a>
<?php endwhile; ?>
</div>
<?php include __DIR__.'/partials/footer.php'; ?>